/** @type {import('next').NextConfig} */
const nextConfig = {
  reactStrictMode: true,
  // For cPanel: use static export (no Node.js server needed)
  // This generates a static site in 'out/' directory
  output: 'export',
  poweredByHeader: false,
  compress: true,
  trailingSlash: true,
  
  env: {
    NEXT_PUBLIC_API_URL: process.env.NEXT_PUBLIC_API_URL || '/api',
  },
  
  // Static export requires unoptimized images
  images: {
    unoptimized: true,
  },
};

module.exports = nextConfig;
