import type { Metadata } from 'next';
import './globals.css';
import { AuthProvider } from '@/context/AuthContext';
import { Toaster } from 'react-hot-toast';

export const metadata: Metadata = {
  title: 'CashBook ERP - Accounting & Bookkeeping for Ghana SMEs',
  description: 'Cloud-based accounting, POS, invoicing, payroll and tax compliance software for small and medium enterprises in Ghana.',
};

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="en">
      <body className="antialiased">
        <AuthProvider>
          {children}
          <Toaster
            position="top-right"
            gutter={8}
            containerStyle={{ top: 16, right: 16 }}
            toastOptions={{
              duration: 4000,
              style: {
                borderRadius: '8px',
                background: '#171717',
                color: '#fff',
                fontSize: '13px',
                padding: '12px 16px',
                maxWidth: '400px',
                boxShadow: '0 8px 30px rgba(0, 0, 0, 0.12)',
              },
              success: {
                style: {
                  background: '#171717',
                  borderLeft: '3px solid #10b981',
                },
                iconTheme: {
                  primary: '#10b981',
                  secondary: '#fff',
                },
              },
              error: {
                style: {
                  background: '#171717',
                  borderLeft: '3px solid #ef4444',
                },
                iconTheme: {
                  primary: '#ef4444',
                  secondary: '#fff',
                },
                duration: 5000,
              },
            }}
          />
        </AuthProvider>
      </body>
    </html>
  );
}
